/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class TimerQueue
implements Runnable {
    Timer firstTimer;
    boolean running;
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    private static Hashtable timerPanels = null;
    static /* synthetic */ Class class$com$sun$java$swing$TimerQueue;

    public TimerQueue() {
        Toolkit.getDefaultToolkit();
        this.start();
    }

    public static TimerQueue sharedInstance() {
        Class clazz = class$com$sun$java$swing$TimerQueue != null ? class$com$sun$java$swing$TimerQueue : (class$com$sun$java$swing$TimerQueue = TimerQueue.class$("com.sun.java.swing.TimerQueue"));
        synchronized (clazz) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            TimerQueue timerQueue2 = timerQueue;
            Object var2_3 = null;
            return timerQueue2;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Thread thread = new Thread((Runnable)this, "TimerQueue");
        try {
            if (thread.getPriority() > 1) {
                thread.setPriority(thread.getPriority() - 1);
            }
            thread.setDaemon(true);
        }
        catch (SecurityException securityException) {}
        thread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long l) {
        if (timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        while (timer3 != null) {
            if (timer3.expirationTime > l) break;
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (timer2 == null) {
            this.firstTimer = timer;
        } else {
            timer2.nextTimer = timer;
        }
        timer.expirationTime = l;
        timer.nextTimer = timer3;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        boolean bl = false;
        while (timer3 != null) {
            if (timer3 == timer) {
                bl = true;
                break;
            }
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (!bl) {
            return;
        }
        if (timer2 == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            timer2.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long l;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            l = timer.expirationTime - l2;
            if (l > 0L) continue;
            if (timerPanels != null) {
                TimerPanel timerPanel = TimerQueue.getActiveTimerPanel();
                if (timerPanel != null) {
                    Vector vector;
                    Vector vector2 = vector = TimerQueue.getExpiredTimers();
                    synchronized (vector2) {
                        vector.addElement(timer);
                    }
                    timerPanel.repaint();
                }
            } else {
                try {
                    timer.post();
                }
                catch (SecurityException securityException) {}
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, l2 + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (l <= 0L);
        return l;
    }

    public synchronized void run() {
        while (this.running) {
            long l = this.postExpiredTimers();
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        Timer timer = this.firstTimer;
        while (timer != null) {
            stringBuffer.append(timer.toString());
            timer = timer.nextTimer;
            if (timer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static synchronized void initAppletTimer(JApplet jApplet) {
        Hashtable hashtable = TimerQueue.getTimerPanels();
        TimerPanel timerPanel = (TimerPanel)hashtable.get(jApplet);
        if (timerPanel == null) {
            timerPanel = new TimerPanel();
            jApplet.getLayeredPane().add(timerPanel);
            hashtable.put(jApplet, timerPanel);
        }
    }

    static synchronized void removeAppletTimer(JApplet jApplet) {
        TimerQueue.getTimerPanels().remove(jApplet);
    }

    static synchronized TimerPanel getActiveTimerPanel() {
        Enumeration enumeration = TimerQueue.getTimerPanels().elements();
        while (enumeration.hasMoreElements()) {
            TimerPanel timerPanel = (TimerPanel)enumeration.nextElement();
            if (!timerPanel.isShowing()) continue;
            return timerPanel;
        }
        return null;
    }

    static Hashtable getTimerPanels() {
        if (timerPanels == null) {
            timerPanels = new Hashtable(2);
        }
        return timerPanels;
    }

    static Vector getExpiredTimers() {
        Vector vector = (Vector)SwingUtilities.appContextGet(expiredTimersKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(expiredTimersKey, vector);
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TimerPanel
    extends Panel {
        TimerPanel() {
            this.setBounds(0, 0, 1, 1);
        }

        public void update(Graphics graphics) {
            Vector vector;
            Vector vector2;
            TimerQueue.sharedInstance();
            Vector vector3 = vector2 = TimerQueue.getExpiredTimers();
            synchronized (vector3) {
                if (vector2.size() == 0) {
                    Object var5_5 = null;
                    return;
                }
                Enumeration enumeration = vector2.elements();
                vector = new Vector();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                vector2 = new Vector();
                SwingUtilities.appContextPut(expiredTimersKey, vector2);
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((Timer)vector.elementAt(n2)).fire();
                ++n2;
            }
        }
    }
}

